//package globalExamples;

import oracle.express.olapi.data.full.ExpressSpecifiedCursorManager;

import oracle.olapi.data.cursor.Cursor;

import oracle.olapi.data.source.CursorManagerSpecification;
import oracle.olapi.data.source.DataProvider;
import oracle.olapi.data.source.NumberSource;
import oracle.olapi.data.source.SpecifiedCursorManager;
import oracle.olapi.data.source.Source;
import oracle.olapi.data.source.StringParameter;
import oracle.olapi.data.source.StringSource;

import oracle.olapi.transaction.TransactionProvider;
import oracle.olapi.transaction.NotCommittableException;

import oracle.olapi.metadata.mdm.MdmAttribute;
import oracle.olapi.metadata.mdm.MdmLevelHierarchy;
import oracle.olapi.metadata.mdm.MdmMeasure;
import oracle.olapi.metadata.mdm.MdmPrimaryDimension;

/**
 * Complete code for Example 7-9, Creating a Cube and Pivoting Its Edges, in 
 * Chapter 7, Making Queries Using Source Methods, in the 
 * Oracle OLAP Developer's Guide to the  OLAP API.
 * 
 * This program uses the Context10g class, which uses the
 * CursorPrintWriter class.
 * @author Oracle Corporation
 */
public class CreatingCubeAndPivotingEdges
{
  public CreatingCubeAndPivotingEdges()
  {
  }
  public void run(String[] args)
  {
    Context10g context = new Context10g(args, false);

    context.println("Example 7-9, Creating a Cube and Pivoting Its Edges\n");
    
    // Get the MdmMeasure for units
    MdmMeasure mdmUnits = context.getMdmMeasureByName("UNITS");
    // Get the Source for the measure
    Source units = mdmUnits.getSource();

    // Get the dimensions of the measure and the default hierarchies of
    // the dimensions
    MdmPrimaryDimension[] mdmPrimDims =
         context.getMdmPrimaryDimensionsByName(new String[]
                                               {"PRODUCT",
                                                "TIME",
                                                "CHANNEL",
                                                "CUSTOMER"});

    MdmPrimaryDimension mdmProdDim = mdmPrimDims[0];
    MdmLevelHierarchy mdmProdDefLvlHier = (MdmLevelHierarchy)
                                           mdmProdDim.getDefaultHierarchy();

    MdmPrimaryDimension mdmTimeDim = mdmPrimDims[1];
    MdmLevelHierarchy mdmTimeDefLvlHier = (MdmLevelHierarchy)
                                           mdmTimeDim.getDefaultHierarchy();

    MdmPrimaryDimension mdmChanDim = mdmPrimDims[2];
    MdmLevelHierarchy mdmChanDefLvlHier = (MdmLevelHierarchy)
                                           mdmChanDim.getDefaultHierarchy();

    MdmPrimaryDimension mdmCustDim = mdmPrimDims[3];
    MdmLevelHierarchy mdmCustDefLvlHier = (MdmLevelHierarchy)
                                           mdmCustDim.getDefaultHierarchy();

    // Get the Source objects for the hierarchies
    StringSource prodHier = (StringSource) mdmProdDefLvlHier.getSource();
    StringSource timeHier = (StringSource) mdmTimeDefLvlHier.getSource();
    StringSource chanHier = (StringSource) mdmChanDefLvlHier.getSource();
    StringSource custHier = (StringSource) mdmCustDefLvlHier.getSource();

    // Get the DataProvider
    DataProvider dp = context.getDataProvider();

    // Get the short description attribute for the dimensions, and the
    // Source objects for the attributes.
    MdmAttribute mdmProdShortDescr =
                               mdmProdDim.getShortValueDescriptionAttribute();
    Source prodShortDescr = mdmProdShortDescr.getSource();
    MdmAttribute mdmCustShortDescr =
                               mdmCustDim.getShortValueDescriptionAttribute();
    Source custShortDescr = mdmCustShortDescr.getSource();
    MdmAttribute mdmTimeShortDescr =
                               mdmTimeDim.getShortValueDescriptionAttribute();
    Source timeShortDescr = mdmTimeShortDescr.getSource();
    // Get the short description attribute for the channel dimension.
    MdmAttribute mdmChanShortDescr =
                               mdmChanDim.getShortValueDescriptionAttribute();
    Source chanShortDescr = mdmChanShortDescr.getSource();

    // Create Parameter objects with values from the CUSTOMER and
    // PRODUCT dimensions.
    StringParameter custParam =
                      new StringParameter(dp, "SHIPMENTS_ROLLUP::REGION::9");
    StringParameter prodParam =
                      new StringParameter(dp, "PRODUCT_ROLLUP::FAMILY::4");

    // Create parameterized Source objects for the default hierarchies of
    // the CUSTOMER and PRODUCT dimensions.
    StringSource custParamSrc = dp.createParameterizedSource(custParam);
    StringSource prodParamSrc = dp.createParameterizedSource(prodParam);

    // Create derived Source objects from the hierarchies, using the
    // parameterized Source objects as the comparison Source objects.
    Source paramCustSel = custHier.join(custHier.value(), custParamSrc);
    Source paramProdSel = prodHier.join(prodHier.value(), prodParamSrc);

    // Select elements from the other dimensions of the measure
    Source timeSel = timeHier.selectValues(new String[] {"CALENDAR::YEAR::2",
                                                         "CALENDAR::YEAR::3",
                                                         "CALENDAR::YEAR::4"});
    
    Source chanSel = chanHier.selectValues(new String[]
                                           {"CHANNEL_ROLLUP::CHANNEL::2",
                                            "CHANNEL_ROLLUP::CHANNEL::3",
                                            "CHANNEL_ROLLUP::CHANNEL::4"});

   // Join the dimension selections to the short description attributes
   // for the dimensions.
   Source columnEdge = chanSel.join(chanShortDescr);
   Source rowEdge = timeSel.join(timeShortDescr);
   Source page1 = paramProdSel.join(prodShortDescr);
   Source page2 = paramCustSel.join(custShortDescr);

   // Join the dimension selections to the measure.
    Source cube = units.join(columnEdge)//.join(chanSel)
                          .join(rowEdge) // .join(timeSel)
                          .join(page2)//.join(paramCustSel)

                          .join(page1);//.join(paramProdSel);

    // Get the TransactionProvider, and prepare and commit the current
    // Transaction.
    TransactionProvider tp = context.getTransactionProvider();
    try
    {
      tp.prepareCurrentTransaction();
    }
    catch(NotCommittableException e)
    {
      context.println("Cannot prepare the current Transaction. " + e);
    }
    tp.commitCurrentTransaction();

    // Create a Cursor for the query.
    CursorManagerSpecification cMngrSpec =
                 dp.createCursorManagerSpecification(cube);
    SpecifiedCursorManager  spCMngr = dp.createCursorManager(cMngrSpec);
    Cursor cubeCursor = spCMngr.createCursor();
    context.displayCursorAsCrosstab(cubeCursor);

    // Change the customer parameter value.
    custParam.setValue("SHIPMENTS_ROLLUP::REGION::10");

    // Reset the Cursor position to 1
    cubeCursor.setPosition(1);
    context.println(" ");
    context.displayCursorAsCrosstab(cubeCursor);

    // Pivot the column and row edges.
    columnEdge = timeSel.join(timeShortDescr);
    rowEdge = chanSel.join(chanShortDescr);
   
   // Join the dimension selections to the measure.
    cube = units.join(columnEdge)
                .join(rowEdge)
                .join(page2)
                .join(page1);

    // Prepare and commit the current Transaction.
    try
    {
      tp.prepareCurrentTransaction();
    }
    catch(NotCommittableException e)
    {
      context.println("Cannot prepare the current Transaction. " + e);
    }
    tp.commitCurrentTransaction();

    // Create another Cursor.
    cMngrSpec = dp.createCursorManagerSpecification(cube);
    spCMngr = dp.createCursorManager(cMngrSpec);
    cubeCursor = spCMngr.createCursor();
    context.displayCursorAsCrosstab(cubeCursor);
    
    // Change the product parameter value.
    prodParam.setValue("PRODUCT_ROLLUP::FAMILY::5");

    // Reset the Cursor position to 1
    cubeCursor.setPosition(1);
    context.println(" ");
    context.displayCursorAsCrosstab(cubeCursor);
  }


  public static void main(String[] args)
  {
    new CreatingCubeAndPivotingEdges().run(args);
  }
}


